#!/bin/sh -ex

# Lake Prevatt
# daily stage plots and stats
wdmtoolbox extract --start_date="1953-01-01 00:00:00" --end_date="2020-12-31 00:00:00" Prevatt_AL.wdm 304 301 > lake_prevatt_stage_SL.csv

tstoolbox describe  < lake_prevatt_stage_SL.csv >  lake_prevatt_stats_SL.csv
tstoolbox gof       < lake_prevatt_stage_SL.csv >> lake_prevatt_stats_SL.csv

plottoolbox time  --ofilename=lkprevatt_Stage_ISLE_WIN_L_sle.png \
     --title="Lake Prevatt Daily Stage" --xtitle="" --ytitle="Stage (ft)" \
     --color="b,r" --linestyles="-,--" --markerstyles="*,None" \
     --legend_names="Obs/extended,Simulated" < lake_prevatt_stage_SL.csv 
tstoolbox read --dropna any lake_prevatt_stage_SL.csv | tee dropped.csv | plottoolbox norm_xaxis  --ofilename=lkprevatt_sdc_ISLE_WIN_L_sle.png \
     --title="Lake Prevatt Daily Stage Duration" --xtitle="Exceedance Probability" --ytitle="Stage (ft)" \
     --color="b,r" --linestyles="-,--" \
     --legend_names="Obs/extended,Simulated" \
      #--yaxis=log < lake_prevatt_stage_SL.csv
plottoolbox xy  --ofilename=lkprevatt_xy_ISLE_WIN_L_sle.png \
    --title="Lake Prevatt Daily Stage Scatterplot" --xtitle="Simulated Stage (ft)" --ytitle="Obs/extended Stage (ft)"\
    --color="b" --linestyles="" --markerstyles=".,." --xy_match_line "-" \
     --legend=False < lake_prevatt_stage_SL.csv

wdmtoolbox extract --start_date="1953-01-01 00:00:00" --end_date="2020-12-31 00:00:00" Prevatt_AL.wdm 304 301 111 > lake_prevatt_stage_SLtest.csv

plottoolbox time  --ofilename=lkprevatt_Stage_ISLE_WIN_Com_sle.png \
     --title=" " --xtitle="" --ytitle="Stage (ft)" \
     --color="b,r,g" --linestyles="-,--,-" --markerstyles="*,None,None" \
     --legend_names="Obs/extended,Simulated,GW" < lake_prevatt_stage_SLtest.csv

# monthly Stage plots
# tstoolbox aggregate --agg_interval monthly < lake_prevatt_stage_SL.csv > lake_prevatt_monthly_stage_SL.csv

# tstoolbox describe  < lake_prevatt_monthly_stage_SL.csv >>  lake_prevatt_stats_SL.csv
# tstoolbox gof       < lake_prevatt_monthly_stage_SL.csv >> lake_prevatt_stats_SL.csv

# plottoolbox time   --ofilename=lkprevatt_mon_Stage_ISLE_WIN_L_sle.png \
     # --title="Lake prevatt Monthly Stage" --xtitle="" --ytitle="Stage (ft)" \
     # --color="b,r" --linestyles="-,--" --markerstyles="None,None" \
     # --legend_names="Obs/extended,Simulated" < lake_prevatt_monthly_stage_SL.csv
# tstoolbox read --dropna any lake_prevatt_monthly_stage_SL.csv | tee dropped.csv | plottoolbox norm_xaxis --ofilename=lkprevatt_mon_sdc_ISLE_WIN_L_sle.png \
     # --title="Lake prevatt Monthly Stage Duration" --xtitle="Exceedance Probability" --ytitle="Stage (ft)" \
     # --color="b,r" --linestyles="-,--" \
     # --legend_names="Obs/extended,Simulated" \
      # --yaxis=log < lake_prevatt_monthly_stage_SL.csv 
# plottoolbox xy --ofilename=lkprevatt_mon_xy_ISLE_WIN_L_sle.png \
    # --title="Lake prevatt Stage Monthly Scatterplot" --xtitle="Simulated Stage (ft)" --ytitle="Obs/extended Stage (ft)"\
    # --color="b" --linestyles="" --markerstyles=".,." --xy_match_line "-" \
    # --legend=False < lake_prevatt_monthly_stage_SL.csv 

hspf_utils detailed --uci Prevatt_LT_ISLE_WIN_2LK.uci Prevatt_land.hbn > lkprevatt_watbal_SL.csv
